import { InterfaceType } from "./InterfaceType";
import { a24f27df954ff8a3d } from "./internal/ab29a65d382bc9b44/a24f27df954ff8a3d";
import { a6d28777ab56c8416 } from "./internal/aa89649a981b0bfc2/a6d28777ab56c8416";
import { StarPrinterFactory } from "./StarPrinterFactory";
export class StarDeviceDiscoveryManager {
    interfaceType = InterfaceType.Unknown;
    printerFactory;
    constructor(interfaceType) {
        a6d28777ab56c8416.log(this).info(a6d28777ab56c8416.createInstanceCreatedString("StarDeviceDiscoveryManager"));
        this.interfaceType = interfaceType;
        this.printerFactory = new StarPrinterFactory();
    }
    onPrinterFound = () => { };
    async discover() {
        try {
            if (this.interfaceType === InterfaceType.Usb) {
                const usbStarDeviceDiscoveryManager = new a24f27df954ff8a3d();
                usbStarDeviceDiscoveryManager.printerFactory = this.printerFactory;
                usbStarDeviceDiscoveryManager.onPrinterFound = (printer) => {
                    this.onPrinterFound(printer);
                };
                await usbStarDeviceDiscoveryManager.discover();
                this.printerFactory.dispose(); // Discovery完了後、StarPrinterFactoryは再利用しない。
                return Promise.resolve();
            }
        }
        catch (error) {
            return Promise.reject(error);
        }
    }
}
